---@meta

---@class ADisplayClusterChromakeyCardActor : ADisplayClusterLightCardActor
local ADisplayClusterChromakeyCardActor = {}


---@class ADisplayClusterLightCardActor : AActor
---@field DistanceFromCenter double
---@field Longitude double
---@field Latitude double
---@field UVCoordinates FVector2D
---@field Spin double
---@field Pitch double
---@field Yaw double
---@field Scale FVector2D
---@field RadialOffset double
---@field bAlwaysFlushToWall boolean
---@field Mask EDisplayClusterLightCardMask
---@field Texture UTexture
---@field Color FLinearColor
---@field Temperature float
---@field Tint float
---@field Exposure float
---@field Gain float
---@field Opacity float
---@field Feathering float
---@field AlphaGradient FLightCardAlphaGradientSettings
---@field bLockToOwningRootActor boolean
---@field bIsUVLightCard boolean
---@field Polygon TArray<FVector2D>
---@field PolygonMask UTexture
---@field DefaultSceneRootComponent USceneComponent
---@field MainSpringArmComponent USpringArmComponent
---@field LightCardTransformerComponent USceneComponent
---@field LightCardComponent UStaticMeshComponent
---@field ExtenderNameToComponentMap TMap<FName, UActorComponent>
---@field LabelComponent UDisplayClusterLabelComponent
---@field StageActorComponent UDisplayClusterStageActorComponent
---@field bIsLightCardFlag boolean
local ADisplayClusterLightCardActor = {}



---@class ADisplayClusterRootActor : AActor
---@field ConfigDataName FName
---@field DisplayClusterRootComponent USceneComponent
---@field DefaultViewPoint UDisplayClusterCameraComponent
---@field SyncTickComponent UDisplayClusterSyncTickComponent
---@field StageGeometryComponent UDisplayClusterStageGeometryComponent
---@field StageIsosphereComponent UDisplayClusterStageIsosphereComponent
---@field InnerFrustumPriority TArray<FDisplayClusterComponentRef>
---@field CurrentConfigData UDisplayClusterConfigurationData
---@field bPreviewInGameEnable boolean
---@field bPreviewInGameRenderFrustum boolean
---@field bPreviewEnable boolean
---@field PreviewRenderTargetRatioMult float
---@field bPreviewEnablePostProcess boolean
---@field bPreviewEnableOverlayMaterial boolean
---@field bEnablePreviewTechvis boolean
---@field bEnablePreviewMesh boolean
---@field bEnablePreviewEditableMesh boolean
---@field PreviewSetttingsSource EDisplayClusterConfigurationRootActorPreviewSettingsSource
---@field bFreezePreviewRender boolean
---@field bPreviewICVFXFrustums boolean
---@field PreviewICVFXFrustumsFarDistance float
---@field TickPerFrame int32
---@field ViewportsPerFrame int32
---@field PreviewMaxTextureDimension int32
---@field BasicDisplayDeviceComponent UDisplayClusterDisplayDeviceBaseComponent
---@field DefaultDisplayDeviceName FName
---@field DefaultDisplayDeviceComponent UDisplayClusterDisplayDeviceBaseComponent
---@field LineBatcherComponent ULineBatchComponent
local ADisplayClusterRootActor = {}

---@param InProceduralMeshComponent UProceduralMeshComponent
function ADisplayClusterRootActor:UpdateProceduralMeshComponentData(InProceduralMeshComponent) end
---@param bReplace boolean
---@return boolean
function ADisplayClusterRootActor:SetReplaceTextureFlagForAllViewports(bReplace) end
---@param bNewPreviewEnablePostProcess boolean
function ADisplayClusterRootActor:SetPreviewEnablePostProcess(bNewPreviewEnablePostProcess) end
---@param bEnable boolean
---@return boolean
function ADisplayClusterRootActor:SetFreezeOuterViewports(bEnable) end
---@param StageActor TScriptInterface<IDisplayClusterStageActor>
---@param DesiredOffsetFromFlush double
---@return boolean
function ADisplayClusterRootActor:MakeStageActorFlushToWall(StageActor, DesiredOffsetFromFlush) end
---@return UDisplayClusterStageGeometryComponent
function ADisplayClusterRootActor:GetStageGeometryComponent() end
---@param WorldPosition FVector
---@param OutPosition FVector
---@param OutNormal FVector
---@return boolean
function ADisplayClusterRootActor:GetFlushPositionAndNormal(WorldPosition, OutPosition, OutNormal) end
---@param WorldPosition FVector
---@param WorldDirection FVector
---@param OutDistance float
---@return boolean
function ADisplayClusterRootActor:GetDistanceToStageGeometry(WorldPosition, WorldDirection, OutDistance) end
---@return UDisplayClusterDisplayDeviceBaseComponent
function ADisplayClusterRootActor:GetDefaultDisplayDevice() end
---@return UDisplayClusterCameraComponent
function ADisplayClusterRootActor:GetDefaultCamera() end
---@return USceneComponent
function ADisplayClusterRootActor:GetCommonViewPoint() end


---@class ADisplayClusterTestPatternsActor : AActor
---@field PostProcessComponent UPostProcessComponent
---@field CalibrationPatterns TMap<FString, UMaterial>
---@field ViewportPPSettings TMap<FString, FPostProcessSettings>
local ADisplayClusterTestPatternsActor = {}



---@class FDisplayClusterClusterEventBase
---@field bIsSystemEvent boolean
---@field bShouldDiscardOnRepeat boolean
local FDisplayClusterClusterEventBase = {}



---@class FDisplayClusterClusterEventBinary : FDisplayClusterClusterEventBase
---@field EventId int32
---@field EventData TArray<uint8>
local FDisplayClusterClusterEventBinary = {}



---@class FDisplayClusterClusterEventJson : FDisplayClusterClusterEventBase
---@field Name FString
---@field Type FString
---@field Category FString
---@field Parameters TMap<FString, FString>
local FDisplayClusterClusterEventJson = {}



---@class FDisplayClusterComponentRef
---@field Name FString
local FDisplayClusterComponentRef = {}



---@class FDisplayClusterNetDriverHelper
local FDisplayClusterNetDriverHelper = {}


---@class FDisplayClusterStageGeometryMap
---@field RenderTarget UTextureRenderTarget2D
local FDisplayClusterStageGeometryMap = {}



---@class FDisplayClusterViewportContext
---@field ViewportID FString
---@field RectLocation FIntPoint
---@field RectSize FIntPoint
---@field ViewLocation FVector
---@field ViewRotation FRotator
---@field ProjectionMatrix FMatrix
---@field bIsRendering boolean
local FDisplayClusterViewportContext = {}



---@class FDisplayClusterViewportStereoContext
---@field ViewportID FString
---@field RectLocation FIntPoint
---@field RectSize FIntPoint
---@field ViewLocation TArray<FVector>
---@field ViewRotation TArray<FRotator>
---@field ProjectionMatrix TArray<FMatrix>
---@field bIsRendering boolean
local FDisplayClusterViewportStereoContext = {}



---@class FLightCardAlphaGradientSettings
---@field bEnableAlphaGradient boolean
---@field StartingAlpha float
---@field EndingAlpha float
---@field Angle float
local FLightCardAlphaGradientSettings = {}



---@class IDisplayClusterBlueprintAPI : IInterface
local IDisplayClusterBlueprintAPI = {}

---@param address FString
---@param Port int32
---@param Event FDisplayClusterClusterEventJson
---@param bPrimaryOnly boolean
function IDisplayClusterBlueprintAPI:SendClusterEventJsonTo(address, Port, Event, bPrimaryOnly) end
---@param address FString
---@param Port int32
---@param Event FDisplayClusterClusterEventBinary
---@param bPrimaryOnly boolean
function IDisplayClusterBlueprintAPI:SendClusterEventBinaryTo(address, Port, Event, bPrimaryOnly) end
---@param Listener TScriptInterface<IDisplayClusterClusterEventListener>
function IDisplayClusterBlueprintAPI:RemoveClusterEventListener(Listener) end
---@return boolean
function IDisplayClusterBlueprintAPI:IsSecondary() end
---@return boolean
function IDisplayClusterBlueprintAPI:IsPrimary() end
---@return boolean
function IDisplayClusterBlueprintAPI:IsModuleInitialized() end
---@return boolean
function IDisplayClusterBlueprintAPI:IsBackup() end
---@return ADisplayClusterRootActor
function IDisplayClusterBlueprintAPI:GetRootActor() end
---@return EDisplayClusterOperationMode
function IDisplayClusterBlueprintAPI:GetOperationMode() end
---@return FString
function IDisplayClusterBlueprintAPI:GetNodeId() end
---@return EDisplayClusterNodeRole
function IDisplayClusterBlueprintAPI:GetClusterRole() end
---@return int32
function IDisplayClusterBlueprintAPI:GetActiveNodesAmount() end
---@param OutNodeIds TArray<FString>
function IDisplayClusterBlueprintAPI:GetActiveNodeIds(OutNodeIds) end
---@param Event FDisplayClusterClusterEventJson
---@param bPrimaryOnly boolean
function IDisplayClusterBlueprintAPI:EmitClusterEventJson(Event, bPrimaryOnly) end
---@param Event FDisplayClusterClusterEventBinary
---@param bPrimaryOnly boolean
function IDisplayClusterBlueprintAPI:EmitClusterEventBinary(Event, bPrimaryOnly) end
---@param Listener TScriptInterface<IDisplayClusterClusterEventListener>
function IDisplayClusterBlueprintAPI:AddClusterEventListener(Listener) end


---@class IDisplayClusterClusterEventListener : IInterface
local IDisplayClusterClusterEventListener = {}

---@param Event FDisplayClusterClusterEventJson
function IDisplayClusterClusterEventListener:OnClusterEventJson(Event) end
---@param Event FDisplayClusterClusterEventBinary
function IDisplayClusterClusterEventListener:OnClusterEventBinary(Event) end


---@class IDisplayClusterComponent : IInterface
local IDisplayClusterComponent = {}


---@class UDefault__DisplayClusterBlueprintGeneratedClass
local UDefault__DisplayClusterBlueprintGeneratedClass = {}


---@class UDisplayClusterBlueprint : UBlueprint
---@field ConfigExport FString
---@field ConfigData UDisplayClusterConfigurationData
---@field AssetVersion int32
local UDisplayClusterBlueprint = {}



---@class UDisplayClusterBlueprintAPIImpl : UObject
local UDisplayClusterBlueprintAPIImpl = {}

---@param address FString
---@param Port int32
---@param Event FDisplayClusterClusterEventJson
---@param bPrimaryOnly boolean
function UDisplayClusterBlueprintAPIImpl:SendClusterEventJsonTo(address, Port, Event, bPrimaryOnly) end
---@param address FString
---@param Port int32
---@param Event FDisplayClusterClusterEventBinary
---@param bPrimaryOnly boolean
function UDisplayClusterBlueprintAPIImpl:SendClusterEventBinaryTo(address, Port, Event, bPrimaryOnly) end
---@param Listener TScriptInterface<IDisplayClusterClusterEventListener>
function UDisplayClusterBlueprintAPIImpl:RemoveClusterEventListener(Listener) end
---@return boolean
function UDisplayClusterBlueprintAPIImpl:IsSecondary() end
---@return boolean
function UDisplayClusterBlueprintAPIImpl:IsPrimary() end
---@return boolean
function UDisplayClusterBlueprintAPIImpl:IsModuleInitialized() end
---@return boolean
function UDisplayClusterBlueprintAPIImpl:IsBackup() end
---@return ADisplayClusterRootActor
function UDisplayClusterBlueprintAPIImpl:GetRootActor() end
---@return EDisplayClusterOperationMode
function UDisplayClusterBlueprintAPIImpl:GetOperationMode() end
---@return FString
function UDisplayClusterBlueprintAPIImpl:GetNodeId() end
---@return EDisplayClusterNodeRole
function UDisplayClusterBlueprintAPIImpl:GetClusterRole() end
---@return int32
function UDisplayClusterBlueprintAPIImpl:GetActiveNodesAmount() end
---@param OutNodeIds TArray<FString>
function UDisplayClusterBlueprintAPIImpl:GetActiveNodeIds(OutNodeIds) end
---@param Event FDisplayClusterClusterEventJson
---@param bPrimaryOnly boolean
function UDisplayClusterBlueprintAPIImpl:EmitClusterEventJson(Event, bPrimaryOnly) end
---@param Event FDisplayClusterClusterEventBinary
---@param bPrimaryOnly boolean
function UDisplayClusterBlueprintAPIImpl:EmitClusterEventBinary(Event, bPrimaryOnly) end
---@param Listener TScriptInterface<IDisplayClusterClusterEventListener>
function UDisplayClusterBlueprintAPIImpl:AddClusterEventListener(Listener) end


---@class UDisplayClusterBlueprintGeneratedClass : UBlueprintGeneratedClass
local UDisplayClusterBlueprintGeneratedClass = {}


---@class UDisplayClusterBlueprintLib : UBlueprintFunctionLibrary
local UDisplayClusterBlueprintLib = {}

---@param address FString
---@param Port int32
---@param Event FDisplayClusterClusterEventJson
---@param bPrimaryOnly boolean
function UDisplayClusterBlueprintLib:SendClusterEventJsonTo(address, Port, Event, bPrimaryOnly) end
---@param address FString
---@param Port int32
---@param Event FDisplayClusterClusterEventBinary
---@param bPrimaryOnly boolean
function UDisplayClusterBlueprintLib:SendClusterEventBinaryTo(address, Port, Event, bPrimaryOnly) end
---@param Listener TScriptInterface<IDisplayClusterClusterEventListener>
function UDisplayClusterBlueprintLib:RemoveClusterEventListener(Listener) end
---@return boolean
function UDisplayClusterBlueprintLib:IsSecondary() end
---@return boolean
function UDisplayClusterBlueprintLib:IsPrimary() end
---@return boolean
function UDisplayClusterBlueprintLib:IsBackup() end
---@return ADisplayClusterRootActor
function UDisplayClusterBlueprintLib:GetRootActor() end
---@return EDisplayClusterOperationMode
function UDisplayClusterBlueprintLib:GetOperationMode() end
---@return FString
function UDisplayClusterBlueprintLib:GetNodeId() end
---@return EDisplayClusterNodeRole
function UDisplayClusterBlueprintLib:GetClusterRole() end
---@param OutAPI TScriptInterface<IDisplayClusterBlueprintAPI>
function UDisplayClusterBlueprintLib:GetAPI(OutAPI) end
---@return int32
function UDisplayClusterBlueprintLib:GetActiveNodesAmount() end
---@param OutNodeIds TArray<FString>
function UDisplayClusterBlueprintLib:GetActiveNodeIds(OutNodeIds) end
---@param RootActor ADisplayClusterRootActor
---@param OutLightCards TSet<ADisplayClusterLightCardActor>
function UDisplayClusterBlueprintLib:FindLightCardsForRootActor(RootActor, OutLightCards) end
---@param RootActor ADisplayClusterRootActor
---@param OutChromakeyCards TSet<ADisplayClusterChromakeyCardActor>
function UDisplayClusterBlueprintLib:FindChromakeyCardsForRootActor(RootActor, OutChromakeyCards) end
---@param Event FDisplayClusterClusterEventJson
---@param bPrimaryOnly boolean
function UDisplayClusterBlueprintLib:EmitClusterEventJson(Event, bPrimaryOnly) end
---@param Event FDisplayClusterClusterEventBinary
---@param bPrimaryOnly boolean
function UDisplayClusterBlueprintLib:EmitClusterEventBinary(Event, bPrimaryOnly) end
---@param OriginalLightcards TArray<ADisplayClusterLightCardActor>
---@param OutNewLightCards TArray<ADisplayClusterLightCardActor>
function UDisplayClusterBlueprintLib:DuplicateLightCards(OriginalLightcards, OutNewLightCards) end
---@param RootActor ADisplayClusterRootActor
---@return ADisplayClusterLightCardActor
function UDisplayClusterBlueprintLib:CreateLightCard(RootActor) end
---@param Listener TScriptInterface<IDisplayClusterClusterEventListener>
function UDisplayClusterBlueprintLib:AddClusterEventListener(Listener) end


---@class UDisplayClusterCameraComponent : USceneComponent
---@field InterpupillaryDistance float
---@field bSwapEyes boolean
---@field StereoOffset EDisplayClusterEyeStereoOffset
local UDisplayClusterCameraComponent = {}

---@return boolean
function UDisplayClusterCameraComponent:ToggleSwapEyes() end
---@param SwapEyes boolean
function UDisplayClusterCameraComponent:SetSwapEyes(SwapEyes) end
---@param InStereoOffset EDisplayClusterEyeStereoOffset
function UDisplayClusterCameraComponent:SetStereoOffset(InStereoOffset) end
---@param Distance float
function UDisplayClusterCameraComponent:SetInterpupillaryDistance(Distance) end
---@return boolean
function UDisplayClusterCameraComponent:GetSwapEyes() end
---@return EDisplayClusterEyeStereoOffset
function UDisplayClusterCameraComponent:GetStereoOffset() end
---@return float
function UDisplayClusterCameraComponent:GetInterpupillaryDistance() end


---@class UDisplayClusterChromakeyCardStageActorComponent : UDisplayClusterStageActorComponent
---@field ICVFXCameras TArray<FSoftComponentReference>
local UDisplayClusterChromakeyCardStageActorComponent = {}



---@class UDisplayClusterDisplayDeviceBaseComponent : USceneComponent
---@field bEnableRenderPass boolean
---@field MeshMaterial UMaterial
---@field PreviewMeshMaterial UMaterial
---@field PreviewMeshTechvisMaterial UMaterial
local UDisplayClusterDisplayDeviceBaseComponent = {}



---@class UDisplayClusterDisplayDeviceComponent : UDisplayClusterDisplayDeviceBaseComponent
---@field Exposure float
---@field Gamma float
---@field ColorConversionSettings FOpenColorIOColorConversionSettings
local UDisplayClusterDisplayDeviceComponent = {}



---@class UDisplayClusterGameEngine : UGameEngine
---@field WorldContextObject UObject
local UDisplayClusterGameEngine = {}



---@class UDisplayClusterICVFXCameraComponent : UCineCameraComponent
---@field CameraSettings FDisplayClusterConfigurationICVFX_CameraSettings
local UDisplayClusterICVFXCameraComponent = {}

---@param NewDepthOfFieldParams FDisplayClusterConfigurationICVFX_CameraDepthOfField
function UDisplayClusterICVFXCameraComponent:SetDepthOfFieldParameters(NewDepthOfFieldParams) end


---@class UDisplayClusterLabelComponent : USceneComponent
---@field RootActor TWeakObjectPtr<ADisplayClusterRootActor>
---@field WidgetComponent UDisplayClusterWidgetComponent
---@field WidgetClass TSoftClassPtr<UDisplayClusterLabelWidget>
---@field WidgetScale float
---@field LabelFlags EDisplayClusterLabelFlags
local UDisplayClusterLabelComponent = {}



---@class UDisplayClusterLabelWidget : UUserWidget
local UDisplayClusterLabelWidget = {}

---@param InText FText
function UDisplayClusterLabelWidget:SetLabelText(InText) end


---@class UDisplayClusterLightCardStageActorComponent : UDisplayClusterStageActorComponent
local UDisplayClusterLightCardStageActorComponent = {}


---@class UDisplayClusterOriginComponent : USceneComponent
local UDisplayClusterOriginComponent = {}


---@class UDisplayClusterPlayerInput : UEnhancedPlayerInput
local UDisplayClusterPlayerInput = {}


---@class UDisplayClusterPreviewShareComponent : UActorComponent
---@field Mode EDisplayClusterPreviewShareMode
---@field UniqueName FString
---@field SourceNDisplayActor TSoftObjectPtr<ADisplayClusterRootActor>
---@field IcvfxCamerasSyncType EDisplayClusterPreviewShareIcvfxSync
---@field MediaOutputs TMap<FString, UMediaOutput>
---@field MediaCaptures TMap<FString, UMediaCapture>
---@field MediaSources TMap<FString, UMediaSource>
---@field MediaPlayers TMap<FString, UMediaPlayer>
---@field MediaTextures TMap<FString, UMediaTexture>
---@field OriginalSourceTextures TMap<FString, UTexture>
---@field OriginalTextureReplaces TMap<FString, boolean>
local UDisplayClusterPreviewShareComponent = {}

---@param NewUniqueName FString
function UDisplayClusterPreviewShareComponent:SetUniqueName(NewUniqueName) end
---@param NewMode EDisplayClusterPreviewShareMode
function UDisplayClusterPreviewShareComponent:SetMode(NewMode) end


---@class UDisplayClusterSceneComponentSync : USceneComponent
local UDisplayClusterSceneComponentSync = {}


---@class UDisplayClusterSceneComponentSyncParent : UDisplayClusterSceneComponentSync
local UDisplayClusterSceneComponentSyncParent = {}


---@class UDisplayClusterSceneComponentSyncThis : UDisplayClusterSceneComponentSync
local UDisplayClusterSceneComponentSyncThis = {}


---@class UDisplayClusterScreenComponent : UStaticMeshComponent
local UDisplayClusterScreenComponent = {}

---@param Size FVector2D
function UDisplayClusterScreenComponent:SetScreenSize(Size) end
---@return FVector2D
function UDisplayClusterScreenComponent:GetScreenSize() end


---@class UDisplayClusterStageActorComponent : UActorComponent
---@field RootActor TSoftObjectPtr<ADisplayClusterRootActor>
local UDisplayClusterStageActorComponent = {}



---@class UDisplayClusterStageGeometryComponent : UActorComponent
---@field NorthGeometryMap FDisplayClusterStageGeometryMap
---@field SouthGeometryMap FDisplayClusterStageGeometryMap
---@field StageBoundingRadius float
local UDisplayClusterStageGeometryComponent = {}

---@return boolean
function UDisplayClusterStageGeometryComponent:IsGeometryMapValid() end
---@param bForceImmediateRedraw boolean
function UDisplayClusterStageGeometryComponent:Invalidate(bForceImmediateRedraw) end
---@param InDirection FVector
---@param OutDistance float
---@param OutNormal FVector
---@return boolean
function UDisplayClusterStageGeometryComponent:GetStageDistanceAndNormal(InDirection, OutDistance, OutNormal) end
---@return float
function UDisplayClusterStageGeometryComponent:GetStageBoundingRadius() end


---@class UDisplayClusterStageIsosphereComponent : UProceduralMeshComponent
---@field IsosphereMesh UStaticMesh
local UDisplayClusterStageIsosphereComponent = {}



---@class UDisplayClusterSyncTickComponent : UActorComponent
local UDisplayClusterSyncTickComponent = {}


---@class UDisplayClusterViewportClient : UGameViewportClient
local UDisplayClusterViewportClient = {}


---@class UDisplayClusterWidgetComponent : UWidgetComponent
local UDisplayClusterWidgetComponent = {}


---@class UDisplayClusterWorldSubsystem : UWorldSubsystem
local UDisplayClusterWorldSubsystem = {}


---@class UDisplayClusterXformComponent : USceneComponent
local UDisplayClusterXformComponent = {}


